<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%delivery_zone_method}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%delivery_zone}}`
 */
class M210511121720AddDeliveryZoneIdColumnToDeliveryZoneMethodTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%delivery_zone_method}}', 'delivery_zone_id', $this->integer()->null());

        // creates index for column `delivery_zone_id`
        $this->createIndex(
            '{{%idx-delivery_zone_method-delivery_zone_id}}',
            '{{%delivery_zone_method}}',
            'delivery_zone_id'
        );

        // add foreign key for table `{{%delivery_zone}}`
        $this->addForeignKey(
            '{{%fk-delivery_zone_method-delivery_zone_id}}',
            '{{%delivery_zone_method}}',
            'delivery_zone_id',
            '{{%delivery_zone}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%delivery_zone}}`
        $this->dropForeignKey(
            '{{%fk-delivery_zone_method-delivery_zone_id}}',
            '{{%delivery_zone_method}}'
        );

        // drops index for column `delivery_zone_id`
        $this->dropIndex(
            '{{%idx-delivery_zone_method-delivery_zone_id}}',
            '{{%delivery_zone_method}}'
        );

        $this->dropColumn('{{%delivery_zone_method}}', 'delivery_zone_id');
    }
}
