<?php

namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;

/**
 * This is the model class for table "{{%DeliveryZoneMethod}}".
 *
 */
class DeliveryZoneMethod extends \bitcream\domicilio\custom\common\models\DeliveryZoneMethod
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
       ]);
    }

     /** Salvataggio method*/
     public static function saveZoneMethod($data, $deliveryMethod){

        $return = false;
        $checkmodel = DeliveryZoneMethod::find()->where(['delivery_zone_id' => $data['delivery_zone_id'], 'delivery_method_id' => $deliveryMethod->id])->one();

        if(!$checkmodel){
            $model = new DeliveryZoneMethod();
            $model->delivery_zone_id = $data['delivery_zone_id'];
            $model->delivery_method_id = $deliveryMethod->id;

            $model->save();
        }

        return $data['delivery_zone_id'];



    }

    public static function deleteDeliveryZoneMethod($id){
        $model = DeliveryZoneMethod::findOne($id);
        $model->delete();
    }

}
