<?php

namespace bitcream\domicilio\custom\backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\domicilio\custom\backend\models\Store;

/**
 * StoreSearch represents the model behind the search form of `bitcream\domicilio\custom\common\models\base\Store`.
 */
class StoreSearch extends Store
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'pre_payment', 'status', 'created_user_id', 'updated_user_id', 'store_manager_id'], 'integer'],
            [['title', 'slug', 'phone_number', 'street', 'postal_code', 'municipality', 'province', 'email', 'web_site', 'facebook', 'instagram', 'whatsapp_number', 'booking_web_site', 'description', 'created_at', 'updated_at', 'longitude', 'latitude'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Store::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'pre_payment' => $this->pre_payment,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
            'store_manager_id' => $this->store_manager_id,
        ]);

          // grid filtering conditions
          $query->andFilterWhere(
            ['>=', 'status', 20]
        );

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'slug', $this->slug])
            ->andFilterWhere(['like', 'phone_number', $this->phone_number])
            ->andFilterWhere(['like', 'street', $this->street])
            ->andFilterWhere(['like', 'postal_code', $this->postal_code])
            ->andFilterWhere(['like', 'municipality', $this->municipality])
            ->andFilterWhere(['like', 'province', $this->province])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'web_site', $this->web_site])
            ->andFilterWhere(['like', 'facebook', $this->facebook])
            ->andFilterWhere(['like', 'instagram', $this->instagram])
            ->andFilterWhere(['like', 'whatsapp_number', $this->whatsapp_number])
            ->andFilterWhere(['like', 'booking_web_site', $this->booking_web_site])
            ->andFilterWhere(['like', 'description', $this->description])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at])
            ->andFilterWhere(['like', 'longitude', $this->longitude])
            ->andFilterWhere(['like', 'latitude', $this->latitude]);

        return $dataProvider;
    }
}
