<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%delivery_zone}}".
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $day_hours_order
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $store_id
 *
 * @property Store $store
 * @property DeliveryZoneMethod[] $deliveryZoneMethods
 * @property MunicipalityDeliveryZone[] $municipalityDeliveryZones
 */
class DeliveryZone extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%delivery_zone}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'store_id'], 'integer'],
            [['name', 'day_hours_order', 'created_at', 'updated_at'], 'string', 'max' => 255],
            [['store_id'], 'exist', 'skipOnError' => true, 'targetClass' => Store::className(), 'targetAttribute' => ['store_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'name' => Yii::t('domicilio', 'Name'),
            'day_hours_order' => Yii::t('domicilio', 'Day Hours Order'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
            'store_id' => Yii::t('domicilio', 'Store ID'),
        ];
    }

    /**
     * Gets query for [[Store]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStore()
    {
        return $this->hasOne(Store::className(), ['id' => 'store_id'])->inverseOf('deliveryZones');
    }

    /**
     * Gets query for [[DeliveryZoneMethods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZoneMethods()
    {
        return $this->hasMany(DeliveryZoneMethod::className(), ['delivery_zone_id' => 'id'])->inverseOf('deliveryZone');
    }

    /**
     * Gets query for [[MunicipalityDeliveryZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMunicipalityDeliveryZones()
    {
        return $this->hasMany(MunicipalityDeliveryZone::className(), ['delivery_zone_id' => 'id'])->inverseOf('deliveryZone');
    }
}
