<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "municipality".
 *
 * @property int $id
 * @property string|null $title
 * @property string|null $slug
 * @property int|null $municipality_parent_id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property MunicipalityDeliveryZone[] $municipalityDeliveryZones
 */
class Municipality extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'municipality';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['municipality_parent_id', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'slug', 'created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'title' => Yii::t('domicilio', 'Title'),
            'slug' => Yii::t('domicilio', 'Slug'),
            'municipality_parent_id' => Yii::t('domicilio', 'Municipality Parent ID'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[MunicipalityDeliveryZones]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getMunicipalityDeliveryZones()
    {
        return $this->hasMany(MunicipalityDeliveryZone::className(), ['municipality_id' => 'id'])->inverseOf('municipality');
    }
}
