<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "{{%store_category}}".
 *
 * @property int $id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $store_id
 * @property int|null $category_id
 *
 * @property Category $category
 * @property Store $store
 */
class StoreCategory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%store_category}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'store_id', 'category_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::className(), 'targetAttribute' => ['category_id' => 'id']],
            [['store_id'], 'exist', 'skipOnError' => true, 'targetClass' => Store::className(), 'targetAttribute' => ['store_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
            'store_id' => Yii::t('domicilio', 'Store ID'),
            'category_id' => Yii::t('domicilio', 'Category ID'),
        ];
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::className(), ['id' => 'category_id'])->inverseOf('storeCategories');
    }

    /**
     * Gets query for [[Store]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getStore()
    {
        return $this->hasOne(Store::className(), ['id' => 'store_id'])->inverseOf('storeCategories');
    }
}
