<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%store_payment_method}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%store_payment_method}}`
 */
class M210507144005AddPaymentMethodIdColumnToStorePaymentMethodTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%store_payment_method}}', 'payment_method_id', $this->integer()->null());

        // creates index for column `payment_method_id`
        $this->createIndex(
            '{{%idx-store_payment_method-payment_method_id}}',
            '{{%store_payment_method}}',
            'payment_method_id'
        );

        // add foreign key for table `{{%payment_method}}`
        $this->addForeignKey(
            '{{%fk-store_payment_method-payment_method_id}}',
            '{{%store_payment_method}}',
            'payment_method_id',
            '{{%payment_method}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%payment_method}}`
        $this->dropForeignKey(
            '{{%fk-store_payment_method-payment_method_id}}',
            '{{%store_payment_method}}'
        );

        // drops index for column `payment_method_id`
        $this->dropIndex(
            '{{%idx-store_payment_method-payment_method_id}}',
            '{{%store_payment_method}}'
        );

        $this->dropColumn('{{%store_payment_method}}', 'payment_method_id');
    }
}
