<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles dropping columns from table `{{%delivery_zone}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%municipality}}`
 */
class M210511100546DropMunicipalityIdColumnFromDeliveryZoneTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // drops foreign key for table `{{%municipality}}`
        $this->dropForeignKey(
            '{{%fk-delivery_zone-municipality_id}}',
            '{{%delivery_zone}}'
        );

        // drops index for column `municipality_id`
        $this->dropIndex(
            '{{%idx-delivery_zone-municipality_id}}',
            '{{%delivery_zone}}'
        );

        $this->dropColumn('{{%delivery_zone}}', 'municipality_id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->addColumn('{{%delivery_zone}}', 'municipality_id', $this->integer()->null());

        // creates index for column `municipality_id`
        $this->createIndex(
            '{{%idx-delivery_zone-municipality_id}}',
            '{{%delivery_zone}}',
            'municipality_id'
        );

        // add foreign key for table `{{%municipality}}`
        $this->addForeignKey(
            '{{%fk-delivery_zone-municipality_id}}',
            '{{%delivery_zone}}',
            'municipality_id',
            '{{%municipality}}',
            'id',
            'CASCADE'
        );
    }
}
