<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%delivery_zone}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%store}}`
 */
class M210514092912AddStoreIdColumnToDeliveryZoneTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%delivery_zone}}', 'store_id', $this->integer()->null());

        // creates index for column `store_id`
        $this->createIndex(
            '{{%idx-delivery_zone-store_id}}',
            '{{%delivery_zone}}',
            'store_id'
        );

        // add foreign key for table `{{%store}}`
        $this->addForeignKey(
            '{{%fk-delivery_zone-store_id}}',
            '{{%delivery_zone}}',
            'store_id',
            '{{%store}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%store}}`
        $this->dropForeignKey(
            '{{%fk-delivery_zone-store_id}}',
            '{{%delivery_zone}}'
        );

        // drops index for column `store_id`
        $this->dropIndex(
            '{{%idx-delivery_zone-store_id}}',
            '{{%delivery_zone}}'
        );

        $this->dropColumn('{{%delivery_zone}}', 'store_id');
    }
}
