<?php

namespace bitcream\domicilio\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%store}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%user}}`
 */
class M210514121809AddStoreManagerIdColumnToStoreTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%store}}', 'store_manager_id', $this->integer()->null());

        // creates index for column `store_manager_id`
        $this->createIndex(
            '{{%idx-store-store_manager_id}}',
            '{{%store}}',
            'store_manager_id'
        );

        // add foreign key for table `{{%user}}`
        $this->addForeignKey(
            '{{%fk-store-store_manager_id}}',
            '{{%store}}',
            'store_manager_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%user}}`
        $this->dropForeignKey(
            '{{%fk-store-store_manager_id}}',
            '{{%store}}'
        );

        // drops index for column `store_manager_id`
        $this->dropIndex(
            '{{%idx-store-store_manager_id}}',
            '{{%store}}'
        );

        $this->dropColumn('{{%store}}', 'store_manager_id');
    }
}
