<?php

namespace bitcream\domicilio\custom\api\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use bitcream\domicilio\custom\api\models\Municipality;

/**
 * MunicipalitySearch represents the model behind the search form of `bitcream\domicilio\custom\common\models\base\Municipality`.
 */
class MunicipalitySearch extends Municipality
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'municipality_parent_id', 'created_user_id', 'updated_user_id'], 'integer'],
            [['title', 'slug', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Municipality::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'municipality_parent_id' => $this->municipality_parent_id,
            'created_user_id' => $this->created_user_id,
            'updated_user_id' => $this->updated_user_id,
        ]);

        $query->andFilterWhere(
            ['>=', 'status', 20]
        );

        $query->andFilterWhere(['like', 'title', $this->title])
            ->andFilterWhere(['like', 'slug', $this->slug])
            ->andFilterWhere(['like', 'created_at', $this->created_at])
            ->andFilterWhere(['like', 'updated_at', $this->updated_at]);

        return $dataProvider;
    }
}
