<?php

namespace bitcream\domicilio\custom\backend\models;

use Yii;
use bitcream\domicilio\custom\common\behaviors\CreateUpdateBehaviors;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\domicilio\custom\common\behaviors\StatusBehaviors;
use bitcream\domicilio\custom\backend\models\MunicipalityDeliveryZone;


/**
 * This is the model class for table "{{%DeliveryZone}}".
 *
 */
class DeliveryZone extends \bitcream\domicilio\custom\common\models\DeliveryZone
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
       ]);
    }

    /**
     * save Municipality
     */
    public function saveMunicipality($municipalityIds)
    {
        /* clear the Municipality of the post before saving */
        MunicipalityDeliveryZone::deleteAll(['delivery_zone_id' => $this->id]);
        if (is_array($municipalityIds)) {
            foreach($municipalityIds as $MunicipalityId) {
                $spm = new MunicipalityDeliveryZone();
                $spm->delivery_zone_id = $this->id;
                $spm->municipality_id = $MunicipalityId;
                $spm->save();
            }
        }
    }
}
