<?php

namespace bitcream\domicilio\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "delivery_method".
 *
 * @property int $id
 * @property int|null $cost
 * @property int|null $minimum_expense
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 *
 * @property DeliveryZoneMethod[] $deliveryZoneMethods
 */
class DeliveryMethod extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'delivery_method';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cost', 'minimum_expense', 'status', 'created_user_id', 'updated_user_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('domicilio', 'ID'),
            'cost' => Yii::t('domicilio', 'Cost'),
            'minimum_expense' => Yii::t('domicilio', 'Minimum Expense'),
            'status' => Yii::t('domicilio', 'Status'),
            'created_at' => Yii::t('domicilio', 'Created At'),
            'created_user_id' => Yii::t('domicilio', 'Created User ID'),
            'updated_at' => Yii::t('domicilio', 'Updated At'),
            'updated_user_id' => Yii::t('domicilio', 'Updated User ID'),
        ];
    }

    /**
     * Gets query for [[DeliveryZoneMethods]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getDeliveryZoneMethods()
    {
        return $this->hasMany(DeliveryZoneMethod::className(), ['delivery_method_id' => 'id'])->inverseOf('deliveryMethod');
    }
}
