<?php

namespace bitcream\fast\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use yii\helpers\Inflector;
/**
 * This is the extended model class for table "{{%product}}".
 */
class Prodotto extends \bitcream\pim\custom\common\models\Product
{    
    public static $modelSlug = "prodotto";
    public static $modelParent = "tipo-prodotto";


    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getCollezione(){        
        return $this->getDynamicAttributeValue("collezione");        
    }

    public function setCollezione($value){        
        return $this->setDynamicAttribute("collezione", $value);        
    }

    public function getSeduta(){        
        return $this->getDynamicAttributeValue("seduta");        
    }

    public function setSeduta($value){        
        return $this->setDynamicAttribute("seduta", $value);        
    }

    public function getModello(){        
        return $this->getDynamicAttributeValue("modello");        
    }

    public function setModello($value){        
        return $this->setDynamicAttribute("modello", $value);        
    }

    public function getNaturall_monocolore(){        
        return $this->getDynamicAttributeValue("naturall_monocolore");        
    }

    public function setNaturall_monocolore($value){        
        return $this->setDynamicAttribute("naturall_monocolore", $value);        
    }

    public function getStruttura(){        
        return $this->getDynamicAttributeValue("struttura");        
    }

    public function setStruttura($value){        
        return $this->setDynamicAttribute("struttura", $value);        
    }

    public function getAlluminio_puntinato(){        
        return $this->getDynamicAttributeValue("alluminio_puntinato");        
    }

    public function setAlluminio_puntinato($value){        
        return $this->setDynamicAttribute("alluminio_puntinato", $value);        
    }

    public function getCorda(){        
        return $this->getDynamicAttributeValue("corda");        
    }

    public function setCorda($value){        
        return $this->setDynamicAttribute("corda", $value);        
    }

    public function getTessuto_cuscino(){        
        return $this->getDynamicAttributeValue("tessuto_cuscino");        
    }

    public function setTessuto_cuscino($value){        
        return $this->setDynamicAttribute("tessuto_cuscino", $value);        
    }

    public function getGres(){        
        return $this->getDynamicAttributeValue("gres");        
    }

    public function setGres($value){        
        return $this->setDynamicAttribute("gres", $value);        
    }

    public function getTelo_lettino(){        
        return $this->getDynamicAttributeValue("telo_lettino");        
    }

    public function setTelo_lettino($value){        
        return $this->setDynamicAttribute("telo_lettino", $value);        
    }

    public function getHpl(){        
        return $this->getDynamicAttributeValue("hpl");        
    }

    public function setHpl($value){        
        return $this->setDynamicAttribute("hpl", $value);        
    }

    public function getTipo_prodotto(){        
        return $this->getDynamicAttributeValue("tipo_prodotto");        
    }

    public function setTipo_prodotto($value){        
        return $this->setDynamicAttribute("tipo_prodotto", $value);        
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductsTranslation()
    {
        return $this->hasMany(ProductTranslation::className(), ['product_id' => 'id']);
    }

    public function fields(){
        return [
            'id',
            'title',
            'collection_id' => 'collectionId',
            'type_product_id' => 'typeProductId',
            'attributes' => 'attributesProduct',
        ];
    }

    public function getTypeProductId(){
        return $this->tipo_prodotto;   
    }

    public function getCollectionId(){
        return $this->collezione;
    }

    public function getAttributesProduct(){
        $attributes = [];
        foreach($this->productModel->attributesObject as $attribute){ //prende gli attributi del modello
            //sel il valore dell'attributo di questo prodotto è vuoto passiamo al prossimo 
            $productValue = $this->getDynamicProductValue($attribute->slug);
            if(!$productValue || empty($productValue->value)) continue;
            if($attribute->isModelValue()){
                $attributes[] = $this->getAttributesModel($productValue); //funzione per attibute model
            }else{
                $attributes[] = $this->getAttributesSimple($productValue); //funzione per attributi semplici
            }         
        }
        return $attributes;
    }

    public function getAttributesModel($productValue){
        $attributesModel = [];
        $attributesModel['label'] = $productValue->attributeObject->title; //prendo il nome dell'attributo
        $attributeValues = $this->getDynamicAttributeValue($productValue->attributeObject->slug);
        if(is_array($attributeValues)){
            foreach($attributeValues as $attributeValue){
				if(empty($this->getProductFields($attributeValue))) continue;
                $attributesModel['items'][] = $this->getProductFields($attributeValue);
            }
        }else{
			if(!empty($this->getProductFields($attributeValue))){
            	$attributesModel['items'][] = $this->getProductFields($attributeValue);
			}
        }
        return $attributesModel;
    }

    public function getAttributesSimple($productValue){
        $attributesSimple = [];
        $attributesSimple['label'] = $productValue->attributeObject->title;
        $attributesSimple['items'] = [
            'id' => $productValue->attributeObject->id,
            'title' => $productValue->attributeObject->title,
            'description' => $productValue->attributeObject->description
        ];
        return $attributesSimple;
    }

    public function getProductFields($productId){
        $product = Product::findOne($productId);
		if(empty($product)) return; //"empty product ".$productId;
        $specificProduct = Prodotto::transformProductToProductModelClass($product);
		if(empty($specificProduct)) return;// "empty specificProduct ".$productId;
        
        $attributesModel = [
            'id' => $product->id,
            'title' => $product->title,
            'description' => $product->description,
            'preview' => (!empty($specificProduct->getImageFields('preview_image')))? $specificProduct->getImageFields('preview_image'): "",
            'thumbnail' => (!empty($specificProduct->getImageFields('thumbnail')))? $specificProduct->getImageFields('thumbnail'): "",
        ];        
        return $attributesModel;
    }

    public static function transformProductToProductModelClass(Product $product){
        switch ($product->productModel->slug) {
            case 'seduta':
                return \bitcream\fast\custom\common\models\Seduta::findOne($product->id);
                break;
            case 'corda':
                return \bitcream\fast\custom\common\models\Corda::findOne($product->id);
                break;
            case 'alluminio_puntinato':
                return \bitcream\fast\custom\common\models\AlluminioPuntinato::findOne($product->id);
                break;
            case 'gres':
                return \bitcream\fast\custom\common\models\Gres::findOne($product->id);
                break;
            case 'hpl':
                return \bitcream\fast\custom\common\models\Hpl::findOne($product->id);
                break;
            case 'sedia':
                return \bitcream\fast\custom\common\models\Sedia::findOne($product->id);
                break;
            case 'struttura':
                return \bitcream\fast\custom\common\models\Struttura::findOne($product->id);
                break;
            case 'telo_lettino':
                return \bitcream\fast\custom\common\models\TeloLettino::findOne($product->id);
                break;
            case 'tessuto_cuscino':
                return \bitcream\fast\custom\common\models\TessutoCuscino::findOne($product->id);
                break;
            case 'tipo_prodotto':
                return \bitcream\fast\custom\common\models\TipoProdotto::findOne($product->id);
                break;
            default:
                # code...
                break;
        }
    }

}