<?php

namespace bitcream\fast\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use yii\helpers\Inflector;
/**
 * This is the extended model class for table "{{%product}}".
 */
class Sedia extends \bitcream\pim\custom\common\models\Product
{    
    public static $modelSlug = "sedia";
    
    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getColore(){        
        return $this->getDynamicAttributeValue("colore");        
    }

    public function setColore($value){        
        return $this->setDynamicAttribute("colore", $value);        
    }
    public function getCorde(){        
        return $this->getDynamicAttributeValue("corde");        
    }

    public function setCorde($value){        
        return $this->setDynamicAttribute("corde", $value);        
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductsTranslation()
    {
        return $this->hasMany(ProductTranslation::className(), ['product_id' => 'id']);
    }


}