<?php

namespace bitcream\fast\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\AttributeValue;
use bitcream\pim\custom\common\models\ProductValue;
use JetBrains\PhpStorm\Language;
use yii\helpers\Inflector;
/**
 * This is the extended model class for table "{{%product}}".
 */
class Prodotto extends \bitcream\pim\custom\common\models\Product
{
    public static $modelSlug = "prodotto";
    public static $modelParent = "tipo-prodotto";


    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getCollezione(){
        return $this->getDynamicAttributeValue("collezione");
    }

    public function setCollezione($value){
        return $this->setDynamicAttribute("collezione", $value);
    }

    public function getSeduta(){
        return $this->getDynamicAttributeValue("seduta");
    }

    public function setSeduta($value){
        return $this->setDynamicAttribute("seduta", $value);
    }

    public function getModello(){
        return $this->getDynamicAttributeValue("modello");
    }

    public function setModello($value){
        return $this->setDynamicAttribute("modello", $value);
    }

    public function getNaturall_monocolore(){
        return $this->getDynamicAttributeValue("naturall_monocolore");
    }

    public function setNaturall_monocolore($value){
        return $this->setDynamicAttribute("naturall_monocolore", $value);
    }

    public function getStruttura(){
        return $this->getDynamicAttributeValue("struttura");
    }

    public function setStruttura($value){
        return $this->setDynamicAttribute("struttura", $value);
    }

    public function getAlluminio_puntinato(){
        return $this->getDynamicAttributeValue("alluminio_puntinato");
    }

    public function setAlluminio_puntinato($value){
        return $this->setDynamicAttribute("alluminio_puntinato", $value);
    }

    public function getCorda(){
        return $this->getDynamicAttributeValue("corda");
    }

    public function setCorda($value){
        return $this->setDynamicAttribute("corda", $value);
    }

    public function getTessuto_cuscino(){
        return $this->getDynamicAttributeValue("tessuto_cuscino");
    }

    public function setTessuto_cuscino($value){
        return $this->setDynamicAttribute("tessuto_cuscino", $value);
    }

    public function getGres(){
        return $this->getDynamicAttributeValue("gres");
    }

    public function setGres($value){
        return $this->setDynamicAttribute("gres", $value);
    }

    public function getTelo_lettino(){
        return $this->getDynamicAttributeValue("telo_lettino");
    }

    public function setTelo_lettino($value){
        return $this->setDynamicAttribute("telo_lettino", $value);
    }

    public function getHpl(){
        return $this->getDynamicAttributeValue("hpl");
    }

    public function setHpl($value){
        return $this->setDynamicAttribute("hpl", $value);
    }

    public function getTipo_prodotto(){
        return $this->getDynamicAttributeValue("tipo_prodotto");
    }

    public function setTipo_prodotto($value){
        return $this->setDynamicAttribute("tipo_prodotto", $value);
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductsTranslation()
    {
        return $this->hasMany(ProductTranslation::className(), ['product_id' => 'id']);
    }

    public function fields(){
        return [
            'id',
            'title',
            'collection_id' => 'collectionId',
            'type_product_id' => 'typeProductId',
            'attributes' => 'attributesProduct',
            'sayduck' => 'SayDuckFields',
        ];
    }

    public function getSayDuckFields(){
        if(empty($this->sayduckProductUUID)) return ["enabled" => false];
        $productSayDuckFields = [
            "enabled" => true,
            // "product-uuid" => "dddb7050-3155-0139-e5f0-0246bde820b8",
            "product-uuid" => $this->sayduckProductUUID,
            "appearance"=> [
                "background" => "light",
                "hide-photo-studio" => false,
                "hide-embed" => true,
                "hide-action-menu" => false,
                "hide-dimensions" => false,
                "show-dimensions-on-load" => false,
                "hide-annotations" => false,
                "show-annotations-on-load" => false,
                "hide-picker" => true,
                "hide-web-ar" => false,
                "enable-qr-code" => true,
                "hide-hand-hint" => false,
                "hide-loading-bar" => false,
                "hide-logo" => true,
            ],
            "configurations" => [ //TODO da prendere dinamicamente
                "initial" => [
                    "deb603c0-3155-0139-ff4d-0246bde820b8" => "deb76310-3155-0139-fe72-0246bde820b8",
                    "dfc45760-3155-0139-63b7-0246bde820b8" => "dfc6dfc0-3155-0139-a812-0246bde820b8",
                    "8415bf80-3156-0139-4ac3-0246bde820b8" => "d7c99fd0-317d-0139-28e6-0246bde820b8",
                ],
            ],
        ];
        return $productSayDuckFields;
    }

    public function getSayDuckAttributeFields(){
        // $random = (int)rand(0,6);
        switch ((int)rand(0,6)) {
            case 1:
                return [
                    "part" => "dfc45760-3155-0139-63b7-0246bde820b8",
                    "variant" => "dfc6dfc0-3155-0139-a812-0246bde820b8",
                ];
                break;
            case 2:
                return [
                    "part" => "8415bf80-3156-0139-4ac3-0246bde820b8",
                    "variant" => "78125240-3892-0139-d94b-4e187b085b97",
                ];
                break;
            case 3:
                return [
                    "part" => "8415bf80-3156-0139-4ac3-0246bde820b8",
                    "variant" => "83f2b450-3895-0139-8d6a-4e187b085b97",
                ];
                break;
            case 4:
                return [
                    "part" => "dfc45760-3155-0139-63b7-0246bde820b8",
                    "variant" => "e01ede90-3155-0139-367e-0246bde820b8",
                ];
                break;
            case 5:
                return [
                    "part" => "deb603c0-3155-0139-ff4d-0246bde820b8",
                    "variant" => "dec547f0-3155-0139-1022-0246bde820b8",
                ];
                break;
            default:
            break;
        }
        return [
            "part" => "deb603c0-3155-0139-ff4d-0246bde820b8",
            "variant" => "dec05380-3155-0139-6c34-0246bde820b8",
        ];
    }

    public function getTypeProductId(){
        return $this->tipo_prodotto;
    }

    public function getCollectionId(){
        return $this->collezione;
    }

    public function getCollectionText()
    {
        return $this->getAttributeValueFromSlug('collezione');
    }
    public function getAttributeValueFromSlug(string $slug)
    {
        return (AttributeValue::find()->where(['id' => (int)$this->$slug])->select('title')->scalar())?:'';
    }

    public function getAttributesProduct(){
        $attributes = [];
        foreach($this->productModel->attributesObject as $attribute){ //prende gli attributi del modello
            //sel il valore dell'attributo di questo prodotto è vuoto passiamo al prossimo
            $productValue = $this->getDynamicProductValue($attribute->slug);
            if(!$productValue || empty($productValue->value)) continue;
            if($attribute->isModelValue()){
                if(!empty($this->getAttributesModel($productValue))){
                    $attributes[] = $this->getAttributesModel($productValue); //funzione per attibute model
                }
            }
            // else{
            //     $attributes[] = $this->getAttributesSimple($productValue); //funzione per attributi semplici
            // }
        }
        return $attributes;
    }

    public function getAttributesModel($productValue, bool $isEn = false){
        if(!$isEn
            && Yii::$app->request->get("language")
            && Yii::$app->request->get("language")=='EN'){
                $isEn = true;
        }
        $attributesModel = [];
        $attributesModel['id'] = $productValue->attributeObject->id; //prendo il nome dell'attributo
        $attributesModel['label'] = $productValue->attributeObject->title; //prendo il nome dell'attributo
        if($isEn){ //if is English
            switch (strtolower($attributesModel['label'])) {
                case 'struttura':
                    $attributesModel['label'] = "Frame";
                    break;
                case 'alluminio puntinato':
                    $attributesModel['label'] = "Speckled aluminium";
                    break;
                case 'seduta':
                    $attributesModel['label'] = "Seat";
                    break;
                case 'corda':
                    $attributesModel['label'] = "Rope";
                    break;
                case 'tessuto cuscino':
                    $attributesModel['label'] = "Fabric cushion";
                    break;
                case 'gres':
                    $attributesModel['label'] = "Gres";
                    break;
                case 'telo lettino':
                    $attributesModel['label'] = "sunlounger textile";
                    break;
                case 'hpl':
                    $attributesModel['label'] = "hpl";
                    break;
                default:
                    break;
            }
        }
        $attributeValues = $this->getDynamicAttributeValue($productValue->attributeObject->slug);
        if(is_array($attributeValues)){
            foreach($attributeValues as $attributeValue){
                $attributeFields = $this->getProductFields($attributeValue);
				if(empty($attributeFields)) continue;
                $sayduckProductAttribute = $this->sayduckProduct
                ?->getSayduckProductAttributes($productValue->attributeObject->id, $attributeValue)->one();
                if(!empty($sayduckProductAttribute)){
                    $attributeFields['sayduck'] = [
                        'part' => $sayduckProductAttribute->sayduck_part,
                        'variant' => $sayduckProductAttribute->sayduck_variant,
                    ];
                }
                $attributesModel['items'][] = $attributeFields;
            }
            return $attributesModel;
        }
        // else{
        //     $attributeValue = $attributeValues;
		// 	if(!empty($this->getProductFields($attributeValue))){
        //     	$attributesModel['items'][] = $this->getProductFields($attributeValue);
		// 	}
        // }
        // return $attributesModel;
        return [];
    }

    public function getAttributesSimple($productValue){
        $attributesSimple = [];
        $attributesSimple['label'] = $productValue->attributeObject->title;
        $attributesSimple['items'] = [
            'id' => $productValue->attributeObject->id,
            'title' => $productValue->attributeObject->title,
            'description' => $productValue->attributeObject->description,
            // 'sayduck' => $this->getSayDuckAttributeFields(),
        ];
        return $attributesSimple;
    }

    public function getProductFields($productId){
        $product = Product::findOne($productId);
		if(empty($product)) return; //"empty product ".$productId;
        $specificProduct = Prodotto::transformProductToProductModelClass($product);
		if(empty($specificProduct)) return;// "empty specificProduct ".$productId;
        $preview = "";
        $thumbnail="";
        if(!empty($specificProduct->getImageFields('preview_image'))){
            $previews = $specificProduct->getImageFields('preview_image');
            $preview = [end($previews)];
        }
        if(!empty($specificProduct->getImageFields('thumbnail'))){
            $thumbnails = $specificProduct->getImageFields('thumbnail');
            $thumbnail = [end($thumbnails)];
        }

        $attributesModel = [
            'id' => $product->id,
            'title' => $product->title,
            'description' => $product->description,
            'preview' => $preview,
            'thumbnail' => $thumbnail,
            // 'sayduck' => $this->getSayDuckAttributeFields(),
        ];
        return $attributesModel;
    }

    public static function transformProductToProductModelClass(Product $product){
        switch ($product->productModel->slug) {
            case 'seduta':
                return \bitcream\fast\custom\common\models\Seduta::findOne($product->id);
                break;
            case 'corda':
                return \bitcream\fast\custom\common\models\Corda::findOne($product->id);
                break;
            case 'alluminio_puntinato':
                return \bitcream\fast\custom\common\models\AlluminioPuntinato::findOne($product->id);
                break;
            case 'gres':
                return \bitcream\fast\custom\common\models\Gres::findOne($product->id);
                break;
            case 'hpl':
                return \bitcream\fast\custom\common\models\Hpl::findOne($product->id);
                break;
            case 'sedia':
                return \bitcream\fast\custom\common\models\Sedia::findOne($product->id);
                break;
            case 'struttura':
                return \bitcream\fast\custom\common\models\Struttura::findOne($product->id);
                break;
            case 'telo_lettino':
                return \bitcream\fast\custom\common\models\TeloLettino::findOne($product->id);
                break;
            case 'tessuto_cuscino':
                return \bitcream\fast\custom\common\models\TessutoCuscino::findOne($product->id);
                break;
            case 'tipo_prodotto':
                return \bitcream\fast\custom\common\models\TipoProdotto::findOne($product->id);
                break;
            default:
                # code...
                break;
        }
    }


    /**
     * Gets query for [[SayduckProduct]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getSayduckProduct()
    {
        return $this->hasOne(SayduckProduct::class, ['product_id' => 'id'])->inverseOf('product');
    }

    /**
     * Gets Variants for [[SayduckProduct]].
     *
     * @return array
     */
    public function getSayduckProductvariants()
    {
        $sayduckProductvariants=[];
        foreach ($this->sayduckProduct?->sayduckProductLiveInfo['parts'] as $partName => $part) {
            foreach ($part['variants'] as $variantName => $variantUuid) {
                $sayduckProductvariants[$part['uuid'].';'.$variantUuid] = $partName.' '.$variantName;
            }
        }
        return $sayduckProductvariants;
    }

    /**
     * Gets selected variants for [[SayduckProduct]].
     *
     * @return array
     * @param integer $attribute_id
     * @param integer $field_id

     */
    public function getSayduckProductvariantsSelected($attribute_id, $field_id )
    {
        $sayduckProductvariantsSelected=[];
        $sayduckProductAttributes = $this->sayduckProduct?->getSayduckProductAttributes($attribute_id,$field_id)->all();

        foreach ($sayduckProductAttributes as $sayduckProductAttribute) {
            $sayduckProductvariantsSelected[] = $sayduckProductAttribute->sayduck_part.';'.$sayduckProductAttribute->sayduck_variant;
        }
        return $sayduckProductvariantsSelected;
    }

    /**
     * Gets UUID for [[SayduckProduct]].
     *
     * @return string
     */
    public function getSayduckProductUUID()
    {
        return $this->sayduckProduct?->sayduck_product_uuid;
    }

    /**
     * set UUID for [[SayduckProduct]].
     *
     * @return boolean
     */
    public function setSayduckProductUUID(string $uuid)
    {
        $sayduckProduct = SayduckProduct::findOne([
            'product_id' => $this->id,
        ]);
        if(!$sayduckProduct){
            $sayduckProduct = new SayduckProduct();
            $sayduckProduct->product_id = $this->id;
        }
        $sayduckProduct->sayduck_product_uuid = $uuid;
        return $sayduckProduct->save();
    }


    /**
     * Save [[SayduckProductAttributes]].
     *
     * @return boolean
     */
    public function setSayduckProductAttributes($attributes)
    {
        $return = true;
        $errors = [];
        SayduckProductAttribute::deleteAll(['product_id' => $this->id]);
        foreach ($attributes as $string_ids => $strings_uuids) {
            $ids = explode('-',$string_ids);
            foreach ($strings_uuids as $string_uuids) {
                $uuids = explode(';',$string_uuids);

                $sayduckProductAttribute = new SayduckProductAttribute();
                $sayduckProductAttribute->product_id = $this->id;
                $sayduckProductAttribute->attribute_id = $ids[0];
                $sayduckProductAttribute->field_id = intval($ids[1]);
                $sayduckProductAttribute->sayduck_part = $uuids[0];
                $sayduckProductAttribute->sayduck_variant = $uuids[1];

                $result = $sayduckProductAttribute->save();
                if(!$result){
                    $errors[] = [
                        'ids' => $ids,
                        'uuids' => $uuids,
                        'errors' => $sayduckProductAttribute->getErrors(),
                    ];
                    $return = false;
                }

            }
        }
        return $return;
    }
}