<?php

namespace bitcream\fast\custom\common\utils;
use Yii;

/**
 * This is the class for create menu left
 */
class Menu
{

    public static function general($applicationItems){
        $items = array();
        $currentUserId = Yii::$app->user->id;
        $currentUserRoles = Yii::$app->authManager->getRolesByUser($currentUserId);

        if (Yii::$app->user->can('viewApplicationItems')){
            if(true){
                $items = array_merge($items, $applicationItems['menuItems']);
            }
        }

        if (Yii::$app->user->can('viewCustomerItems')){
            if(true){
                $items = array_merge($items, $applicationItems['menuCustomer']);
            }
        }

        if (Yii::$app->user->can('viewSysadminMenu')){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::sysAdminItems());
            }
        }

        if (Yii::$app->user->can('viewPimAdmin')){
            //se l'utente è amministratore
            if(true){
                $items = array_merge($items, Menu::pimAdminItems());
            }
        }
        return $items;

    }

    public static function pimAdminItems(){
        return [
                [
                    'label' => Yii::t('app', 'Pim Admin'),
                    'icon' => 'fontawesome fa fa-cogs',
                    'url' => '#',
                    'items' => [
                        [   
                            'label' => Yii::t('app', 'Attribute'),
                            'url' => ['/pim/attribute/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ],  
                        [   
                            'label' => Yii::t('app', 'AttributeTranslation'),
                            'url' => ['/pim/attribute-translation/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ],  
                        [   
                            'label' => Yii::t('app', 'AttributeValue'),
                            'url' => ['/pim/attribute-value/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ],  
                        [   
                            'label' => Yii::t('app', 'Product'),
                            'url' => ['/pim/product/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ],  
                        [   
                            'label' => Yii::t('app', 'ProductModel'),
                            'url' => ['/pim/product-model/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ],  
                        [   
                            'label' => Yii::t('app', 'ProductValue'),
                            'url' => ['/pim/product-value/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ], 
                        [   
                            'label' => Yii::t('app', 'ProductModelValue'),
                            'url' => ['/pim/product-model-value/index'],
                            'icon' => 'fontawesome fa fa-th-list',
                        ], 
                    ]
                ],
            ];
    }

    public static function sysAdminItems(){
        return [
            [
                'label' => Yii::t('app', 'SysAdmin'),
                'icon' => 'fontawesome fa fa-cogs',
                'url' => '#',
                'items' => [
                    [   'label' => Yii::t('app', 'Users'),
                        'url' => ['/users/user/index'],
                        'icon' => 'fontawesome fa fa-user',
                    ],
                    [
                        'label' => Yii::t('app', 'Users Permissions'),
                        'url' => ['/permissions/auth-item/auth'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [
                        'label' => Yii::t('app', 'Users Roles'),
                        'url' => ['/permissions/auth-item/rule'],
                        'icon' => 'fontawesome fa fa-user'
                    ],
                    [   'label' => Yii::t('app', 'Options'),
                        'url' => ['/options/option/index'],
                        'icon' => 'fontawesome fa fa-cog'
                    ],
                ]
            ],
        ];
    }

}
