<?php

use yii\helpers\Html;
use Emberware\Evidia\Model\Datatable\common\models\DataTableCustom;

?>
<div class="prodotto-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'prodotto-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Title'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->title, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'attribute'=>Yii::t('app', 'Collection'),
                    'format'=>'raw',
                    'value' => 'collectionText',
                ],
                [
                    'attribute'=>Yii::t('app', '3D info'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a(Yii::t('app', '3D'), [Yii::$app->controller->id.'/update-sayduck','id'=>$data->id], ['class' => 'btn btn-primary']);},
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>