<?php

namespace bitcream\fast\custom\common\models\base;

use bitcream\fast\custom\common\models\Prodotto;
use bitcream\pim\custom\common\models\Attribute;
use Yii;

/**
 * This is the model class for table "{{%sayduck_product_attribute}}".
 *
 * @property int $id
 * @property int $product_id
 * @property int $attribute_id
 * @property int $field_id
 * @property string|null $sayduck_part
 * @property string|null $sayduck_variant
 *
 * @property Attribute $productAttribute
 * @property Prodotto $field
 * @property Prodotto $product
 */
class SayduckProductAttribute extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%sayduck_product_attribute}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_id', 'attribute_id', 'field_id'], 'required'],
            [['product_id', 'attribute_id', 'field_id'], 'integer'],
            [['sayduck_part', 'sayduck_variant'], 'string', 'max' => 255],
            [['attribute_id'], 'exist', 'skipOnError' => true, 'targetClass' => Attribute::className(), 'targetAttribute' => ['attribute_id' => 'id']],
            [['field_id'], 'exist', 'skipOnError' => true, 'targetRelation' => 'product'],
            [['product_id'], 'exist', 'skipOnError' => true, 'targetClass' => Prodotto::className(), 'targetAttribute' => ['product_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'product_id' => Yii::t('app', 'Product ID'),
            'attribute_id' => Yii::t('app', 'Attribute ID'),
            'field_id' => Yii::t('app', 'Field ID'),
            'sayduck_part' => Yii::t('app', 'Sayduck Part'),
            'sayduck_variant' => Yii::t('app', 'Sayduck Variant'),
        ];
    }

    /**
     * Gets query for [[ProductAttribute]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductAttribute()
    {
        return $this->hasOne(Prodotto::className(), ['id' => 'attribute_id']);
    }

    /**
     * Gets query for [[Field]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getField()
    {
        return $this->hasOne(Prodotto::className(), ['id' => 'field_id']);
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        return $this->hasOne(Prodotto::className(), ['id' => 'product_id']);
    }
}
