<?php

namespace bitcream\fast\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use yii2tech\ar\softdelete\SoftDeleteBehavior;

/**
 * This is the model common class for table "sayduck_product".
 */
class SayduckProduct extends base\SayduckProduct
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            // 'softDeleteBehavior' => [
            //     'class' => SoftDeleteBehavior::className(),
            //     'softDeleteAttributeValues' => [
            //         'status' => 0
            //     ],
            //     'replaceRegularDelete' => true // mutate native `delete()` method
            // ],
            // 'status' => [
            //     'class' => StatusBehaviors::className(),
            // ],
            // 'create-update' => [
            //     'class' => CreateUpdateBehaviors::className(),
            // ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }


    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     * @param $attribute_id
     * @param $field_id
     */
    public function getSayduckProductAttributes($attribute_id = null, $field_id = null)
    {
            $query = $this->hasMany(SayduckProductAttribute::class, ['product_id' => 'product_id'])->inverseOf('sayduckProduct');
            if(!empty($attribute_id)) $query->andWhere(['attribute_id' => $attribute_id,]);
            if(!empty($field_id)) $query->andWhere(['field_id' => $field_id,]);
        return $query;
    }

    public function getSayduckProductLiveInfo()
    {
        $liveInfo = [];
        $liveData = $this->callSayduckProductLiveInfo();
        $liveInfo = [
            'name' => $liveData?->name,
            'uuid' => $liveData?->uuid,
        ];
        foreach ($liveData?->model?->allConfigurations?->nodes as  $part) {
            $variants = [];
            foreach ($part?->liveVariants?->nodes as $variant) {
                $variants[$variant?->name] = $variant?->uuid;
            }
			if(!empty($variants)){
				$liveInfo['parts'][$part?->name] = [
					'uuid' => $part?->uuid,
					'variants' => $variants,
				];
			}
        }
        return $liveInfo;
    }

    public function callSayduckProductLiveInfo(){

        $curl = curl_init();
        $graphQLquery = '{
            "query":"query GetProduct($uuid: ID, $setEmbbededFlag: Boolean) {\\r\\n  product(uuid: $uuid, setEmbbededFlag: $setEmbbededFlag) {\\r\\n    id\\r\\n    uuid\\r\\n    name\\r\\n    subtitle\\r\\n    features {\\r\\n      nodes {\\r\\n        id\\r\\n        name\\r\\n        unit\\r\\n        value\\r\\n      }\\r\\n    }\\r\\n    model {\\r\\n      id\\r\\n      allConfigurations {\\r\\n        nodes {\\r\\n          ...ConfigurationFields\\r\\n        }\\r\\n      }\\r\\n    }\\r\\n  }\\r\\n}\\r\\nfragment ConfigurationFields on Configuration {\\r\\n  id\\r\\n  isOptional\\r\\n  displayPosition\\r\\n  name\\r\\n  label\\r\\n  uuid\\r\\n  liveVariants {\\r\\n    nodes {\\r\\n      ...VariantFields\\r\\n    }\\r\\n  }\\r\\n}\\r\\nfragment VariantFields on Variant {\\r\\n  id\\r\\n  uuid\\r\\n  displayPosition\\r\\n  name\\r\\n}\\r\\n\\r\\n",
            "variables":{
                "uuid":"'.$this->sayduck_product_uuid.'",
                "setEmbbededFlag":true
            }
        }';
        // return $graphQLquery;

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://api.sayduck.io/graphql',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $graphQLquery,
          CURLOPT_HTTPHEADER => array(
            'content-type: application/json'
          ),
        ));

        $response = curl_exec($curl);
        error_log('$response'.$response);

        curl_close($curl);
        if($response) return json_decode($response)?->data?->product;
        return curl_error($curl);
    }

}
