<?php

namespace bitcream\fast\custom\common\models\base;

use bitcream\fast\custom\common\models\Prodotto;
use Yii;

/**
 * This is the model class for table "{{%sayduck_product}}".
 *
 * @property int $id
 * @property int $product_id
 * @property string|null $sayduck_product_uuid
 *
 * @property Prodotto $product
 */
class SayduckProduct extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%sayduck_product}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['product_id'], 'required'],
            [['product_id'], 'integer'],
            [['sayduck_product_uuid'], 'string', 'max' => 255],
            [['product_id'], 'exist', 'skipOnError' => true, 'targetClass' => Prodotto::className(), 'targetAttribute' => ['product_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'product_id' => Yii::t('app', 'Product ID'),
            'sayduck_product_uuid' => Yii::t('app', 'Sayduck Product Uuid'),
        ];
    }

    /**
     * Gets query for [[Product]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProduct()
    {
        return $this->hasOne(Prodotto::className(), ['id' => 'product_id'])->inverseOf('sayduckProduct');
    }
}
