<?php

namespace bitcream\fast\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\Product;
use bitcream\pim\custom\common\models\Attribute;
use bitcream\pim\custom\common\models\ProductValue;
use yii\helpers\Inflector;
/**
 * This is the extended model class for table "{{%product}}".
 */
class Struttura extends \bitcream\pim\custom\common\models\Product
{    
    public static $modelSlug = "struttura";


    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }

    public function getColore(){        
        return $this->getDynamicAttributeValue("colore");        
    }

    public function setColore($value){        
        return $this->setDynamicAttribute("colore", $value);        
    }
    public function getThumbnail(){        
        return $this->getDynamicAttributeValue("thumbnail");        
    }

    public function setThumbnail($value){        
        return $this->setDynamicAttribute("thumbnail", $value);        
    }
    public function getPreview_image(){        
        return $this->getDynamicAttributeValue("preview_image");        
    }

    public function setPreview_image($value){        
        return $this->setDynamicAttribute("preview_image", $value);        
    }

    /**
     * Gets query for [[Products]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getProductsTranslation()
    {
        return $this->hasMany(ProductTranslation::className(), ['product_id' => 'id']);
    }


}