<?php

namespace bitcream\fast\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%sayduck_product_attribute}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 * - `{{%attribute}}`
 * - `{{%product}}`
 */
class M221122235617CreateSayduckProductAttributeTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%sayduck_product_attribute}}', [
            'id' => $this->primaryKey(),
            'product_id' => $this->integer()->notNull(),
            'attribute_id' => $this->integer()->notNull(),
            'field_id' => $this->integer()->notNull(),
            'sayduck_part' => $this->string(),
            'sayduck_variant' => $this->string(),
        ]);

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-sayduck_product_attribute-product_id}}',
            '{{%sayduck_product_attribute}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-sayduck_product_attribute-product_id}}',
            '{{%sayduck_product_attribute}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );

        // creates index for column `attribute_id`
        $this->createIndex(
            '{{%idx-sayduck_product_attribute-attribute_id}}',
            '{{%sayduck_product_attribute}}',
            'attribute_id'
        );

        // add foreign key for table `{{%attribute}}`
        $this->addForeignKey(
            '{{%fk-sayduck_product_attribute-attribute_id}}',
            '{{%sayduck_product_attribute}}',
            'attribute_id',
            '{{%attribute}}',
            'id',
            'CASCADE'
        );

        // creates index for column `field_id`
        $this->createIndex(
            '{{%idx-sayduck_product_attribute-field_id}}',
            '{{%sayduck_product_attribute}}',
            'field_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-sayduck_product_attribute-field_id}}',
            '{{%sayduck_product_attribute}}',
            'field_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-sayduck_product_attribute-product_id}}',
            '{{%sayduck_product_attribute}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-sayduck_product_attribute-product_id}}',
            '{{%sayduck_product_attribute}}'
        );

        // drops foreign key for table `{{%attribute}}`
        $this->dropForeignKey(
            '{{%fk-sayduck_product_attribute-attribute_id}}',
            '{{%sayduck_product_attribute}}'
        );

        // drops index for column `attribute_id`
        $this->dropIndex(
            '{{%idx-sayduck_product_attribute-attribute_id}}',
            '{{%sayduck_product_attribute}}'
        );

        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-sayduck_product_attribute-field_id}}',
            '{{%sayduck_product_attribute}}'
        );

        // drops index for column `field_id`
        $this->dropIndex(
            '{{%idx-sayduck_product_attribute-field_id}}',
            '{{%sayduck_product_attribute}}'
        );

        $this->dropTable('{{%sayduck_product_attribute}}');
    }
}
