<?php

namespace bitcream\fast\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles the creation of table `{{%sayduck_product}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M221122235800CreateSayduckProductTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%sayduck_product}}', [
            'id' => $this->primaryKey(),
            'product_id' => $this->integer()->notNull(),
            'sayduck_product_uuid' => $this->string(),
        ]);

        // creates index for column `product_id`
        $this->createIndex(
            '{{%idx-sayduck_product-product_id}}',
            '{{%sayduck_product}}',
            'product_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-sayduck_product-product_id}}',
            '{{%sayduck_product}}',
            'product_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-sayduck_product-product_id}}',
            '{{%sayduck_product}}'
        );

        // drops index for column `product_id`
        $this->dropIndex(
            '{{%idx-sayduck_product-product_id}}',
            '{{%sayduck_product}}'
        );

        $this->dropTable('{{%sayduck_product}}');
    }
}
