<?php

namespace bitcream\fast\custom\api\controllers;

use Yii;
use yii\rest\ActiveController;
use yii\filters\AccessControl;
use bitcream\fast\custom\common\models\Prodotto;
use bitcream\fast\custom\common\models\SayduckProduct;
use yii\data\ActiveDataFilter;
use yii\data\ActiveDataProvider;

class ProductController extends ActiveController
{
    public $modelClass = 'bitcream\fast\custom\common\models\Prodotto';

    /**
     * @inheritdoc
    */

    // public function behaviors(): array
    // {
    //     // return array_merge(parent::behaviors(),
    //     //     [
    //     //         'authenticator' => [
    //     //             'class' => \Kakadu\Yii2JwtAuth\JwtBearerAuth::class,
    //     //             'except' => ['options'],
    //     //         ],
    //     //         'access'        => [
    //     //             'class' => AccessControl::class,
    //     //             'rules' => [
    //     //                 [
    //     //                     'allow' => true,
    //     //                     'roles' => ['@'],
    //     //                 ],
    //     //             ],
    //     //         ],
    //     //     ]
    //     // );
    // }

    public function actions(){
        $actions = parent::actions();
        $actions['index']['prepareDataProvider'] = [$this, 'prepareDataProvider'];
        return $actions;
    }

    public function prepareDataProvider(){
        $filter = new ActiveDataFilter([
            'searchModel' => 'bitcream\fast\custom\backend\models\ProdottoSearch'
        ]);

        $filterCondition = null;

        // You may load filters from any source. For example,
        // if you prefer JSON in request body,
        // use Yii::$app->request->getBodyParams() below:
        if ($filter->load(\Yii::$app->request->get())) {
            $filterCondition = $filter->build();
            if ($filterCondition === false) {
                // Serializer would get errors out of it
                return $filter;
            }
        }
        $query = Prodotto::find();

        if ($filterCondition !== null) {
            $query->andWhere($filterCondition);
        }

        return new ActiveDataProvider([
            'query' => $query,
        ]);
    }

    public function actionWithSayduck()
    {
        return SayduckProduct::find()->select('product_id')->column();
    }
}
