<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\Decoration;
use bitcream\ndt\custom\common\models\DecorationSearch;
use bitcream\pim\custom\common\models\ProductModel;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DecorationController implements the CRUD actions for Decoration model.
 */
class DecorationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Decoration models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new DecorationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Decoration model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Decoration model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Decoration();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['update', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'productModels' => ProductModel::find()->all(),
            'decorationParents' => Decoration::find()->where(['status' => 30])->all()
        ]);
    }

    /**
     * Updates an existing Decoration model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) ) {
            $model->code = Yii::$app->request->post()['Decoration']['code'];
            $model->temporary_code = Yii::$app->request->post()['Decoration']['temporary_code'];
            //$model->color = Yii::$app->request->post()['Decoration']['color'];
            //$model->new_in = Yii::$app->request->post()['Decoration']['new_in'];
            //$model->highlights = Yii::$app->request->post()['Decoration']['highlights'];
            //$model->development = Yii::$app->request->post()['Decoration']['development'];
            $model->maximum_print_height = Yii::$app->request->post()['Decoration']['maximum_print_height'];
            $model->number_of_cylinders = Yii::$app->request->post()['Decoration']['number_of_cylinders'];
            $model->metallic_effect = Yii::$app->request->post()['Decoration']['metallic_effect'];
            $model->touch_effect = Yii::$app->request->post()['Decoration']['touch_effect'];
            //$model->features = Yii::$app->request->post()['Decoration']['features'];
            //$model->intended_use = Yii::$app->request->post()['Decoration']['intended_use'];
            //$model->online_from = Yii::$app->request->post()['Decoration']['online_from'];
            //$model->online_to = Yii::$app->request->post()['Decoration']['online_to'];
            $model->save();
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'decorationParents' => Decoration::find()->where(['status' => 30])->andWhere(['!=', 'id', $id])->all(),
            'productModels' => ProductModel::find()->all(),
        ]);
    }

    /**
     * Deletes an existing Decoration model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Decoration model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Decoration the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Decoration::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
