<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\DecorationColor */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="decoration-color-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'decoration_id')->widget(Select2::classname(), [
                'name' => 'decoration_id',
                'class' => 'form-group decoration_ids form-control',
                'value' => ArrayHelper::map($decorations, 'id', function ($decoration) {
                    return $decoration['title'];
                }),
                'id' => 'decoration_id',
                'data' => ArrayHelper::map($decorations, 'id', function ($decoration) {
                    return $decoration['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select decoration')]
            ])->label(Yii::t('app', 'Decoration'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'band_of_decoration_id')->widget(Select2::classname(), [
                'name' => 'band_of_decoration_id',
                'class' => 'form-group band_of_decoration_ids form-control',
                'value' => ArrayHelper::map($bandOfDecorations, 'id', function ($bandOfDecoration) {
                    return $bandOfDecoration['introduction_text'];
                }),
                'id' => 'decoration_id',
                'data' => ArrayHelper::map($bandOfDecorations, 'id', function ($bandOfDecoration) {
                    return $bandOfDecoration['introduction_text'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select band of decoration')]
            ])->label(Yii::t('app', 'Band of decoration'));?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
