<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Field\WYSIWYG;
use Emberware\Evidia\Toolkit\Field\SwitchInput;
use Emberware\Evidia\Toolkit\Field\Date;
use bitcream\ndt\custom\common\widget\ProductFieldWidget;
/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\Decoration */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="decoration-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'title')->textInput(['maxlength' => true]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'short_title')->textInput(['maxlength' => true]) ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'description')->widget(WYSIWYG::className()) ?>
            </div>
        </div>        

        <?php
        if(isset($model->productModel)){
            foreach($model->productModel->attributesObject as $attribute){?>
                <div class='row'>
                    <div class='col-md-6 col-xs-12'>
                        <?= $form->field($model, $attribute->slug)->widget(ProductFieldWidget::classname()) ?>
                    </div>
                </div>
            <?php }
        }
        ?>
        
        <!--
        <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?= $form->field($model, 'color')->textInput(['rows' => 6]) ?>
            </div>
        </div>   
        !-->
         
        <!-- <div class='row'>
            <div class='col-md-6 col-xs-12'>
                <?php //$form->field($model, 'image')->widget(ProductFieldWidget::classname())  ?>

            </div>
        </div>

        <div class='row'>
            <div class='col-md-6 col-xs-12'>
            <?php // $form->field($model, 'gallery')->widget(ProductFieldWidget::classname())  ?>

            </div>
        </div> -->

        <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_parent_id')->widget(Select2::classname(), [
                'name' => 'product_parent_id',
                'class' => 'form-group product_parent_ids form-control',
                'value' => ArrayHelper::map($decorationParents, 'id', function ($decorationParent) {
                    return $decorationParent['title'];
                }),
                'id' => 'product_parent_id',
                'data' => ArrayHelper::map($decorationParents, 'id', function ($decorationParent) {
                    return $decorationParent['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product parent')]
            ])->label(Yii::t('app', 'Decoration parent'));?>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'product_model_id')->widget(Select2::classname(), [
                'name' => 'product_model_id',
                'class' => 'form-group product_model_ids form-control',
                'value' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'id' => 'product_model_id',
                'data' => ArrayHelper::map($productModels, 'id', function ($productModel) {
                    return $productModel['name'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select product model')]
            ])->label(Yii::t('app', 'Product model'));?>
        </div>
    </div>

        <div class="form-group">
            <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
        </div>

    <?php ActiveForm::end(); ?>

</div>
