<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="favourites-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->customerUser->name." ".$data->customerUser->surname." - ".$data->collection->title." - ".$data->decorationColor->bandOfDecoration->introduction_text, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>