<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\ProductTranslation;
use bitcream\ndt\custom\common\models\ProductTranslationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;
/**
 * ProductTranslationController implements the CRUD actions for ProductTranslation model.
 */
class ProductTranslationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => ['login', 'error'],
                        'allow' => true,
                    ],
                    [
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all ProductTranslation models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new ProductTranslationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single ProductTranslation model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new ProductTranslation model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($product_id, $controller)
    {
        $model = new ProductTranslation();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $languages_to_set = isset(Yii::$app->request->post()['language_check']) ? Yii::$app->request->post()['language_check'] :[];
            $model->setLanguages($languages_to_set);
            return $this->redirect([$controller.'/index']);
        }

        return $this->render('create', [
            'model' => $model,
            'product_id' => $product_id,
        ]);
    }

    /**
     * Updates an existing ProductTranslation model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id,$product_id, $controller)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            $languages_to_set = isset(Yii::$app->request->post()['language_check']) ? Yii::$app->request->post()['language_check'] :[];
            $model->setLanguages($languages_to_set);
            return $this->redirect([$controller.'/index']);
        }

        return $this->render('update', [
            'model' => $model,
            'product_id' => $product_id,
        ]);
    }

    /**
     * Deletes an existing ProductTranslation model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $controller)
    {
        $this->findModel($id)->delete();

        return $this->redirect([$controller.'/index']);
    }

    /**
     * Finds the ProductTranslation model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return ProductTranslation the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = ProductTranslation::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
