<?php
namespace bitcream\ndt\custom\common\behaviors;

use yii\base\Behavior;
use yii\db\ActiveRecord;
use bitcream\ndt\custom\common\models\Language;

class LanguageBehaviors extends Behavior
{
    public function events()
    {
        return [
            ActiveRecord::EVENT_BEFORE_DELETE => 'deleteObjectTranslation',
        ];
    }
    public function deleteObjectTranslation(){
        $this->owner->setLanguage($this->owner->getLanguageObject()->label, 0);
    }
    public $langs = [];

    public function setLanguage(string $language, $value){

        $model = Language::find()->where(['object_id' => $this->owner->id, 'class' =>$this->owner->className(), 'label' => $language])->one();

        if(!$model){
            $model = new Language();
            $model->class = $this->owner->className();
            $model->object_id = $this->owner->id;
            $model->label = $language;
        }
        $model->value = $value;

        $model->save(false);
    }

    public function getLanguages(){

        $languages = array();

        foreach($this->langs as $language){
            $value = $this->getLanguage($language);

            array_push($languages, ['language' => $language, 'value' => $value]);
        }

        return $languages;
    }

    public function getLanguage($language){

        $model = Language::find()->where(['object_id' => $this->owner->id, 'class' =>$this->owner->className(), 'label' => $language])->one();
        if($model){
            $value =  $model->value;
        }else{
            $value = false;
        }
        return $value;
    }

    public function getLanguageObject(){

        $language = Language::find()->where(['object_id' => $this->owner->id, 'class' =>$this->owner->className(), 'value' => '1'])->one();
        if ($language){
            return $language;
        }
        return false;
    }

    public function getLanguageIt(){
        return $this->getLanguage("it");
    }

    //Eliminazione record quando viene eliminato un contenuto
    // public function deleteLanguage(){
    // }
    public function setLanguages (array $languages_to_set = []){
        $languages = $this->getLanguages();
        foreach($languages as $language){
            if(!in_array($language['language'], $languages_to_set)){
                $this->setLanguage($language['language'], false);
            }
        }
        foreach($languages_to_set as $language_to_set){
            $this->setLanguage($language_to_set, true);
        }
    }

    public function getAllLanguages(){
        return $this->langs;
    }
}
