<?php
namespace bitcream\ndt\custom\common\widget;

use yii\widgets\InputWidget;
use Emberware\Evidia\Field\FlagIcon\FlagIcon;
use yii\helpers\Html;
use Yii;
use bitcream\ndt\custom\common\widget\AssetWidget;

class LanguageFlagWidget extends InputWidget
{
    public $languages;
    public $language;
    public $countryCode;

    public function init()
    {
        parent::init();
        $this->language = $this->currentLanguage();
        AssetWidget::register($this->getView());
    }

    public function run()
    {
        if($this->language){
            if($this->language == "en"){
                $this->countryCode = "gb";
            }else{
                $this->countryCode = $this->language;
            }
            return "<br><input type='hidden' id='checkbox-".$this->language."' value='".$this->language."' name='language_check[]'>".
                    FlagIcon::widget([
                        'countryCode' => $this->countryCode,
                        'options' => [
                            'class' => 'flag-page'
                        ]
                    ]);
        }else{
            foreach($this->languages as $language){
                if($language["language"] == "en"){
                    $this->countryCode = "gb";
                }else{
                    $this->countryCode = $language["language"];
                }
                if($language["value"] == true){
                    return "<br><input type='hidden' id='checkbox-".$language["language"]."' value='".$language["language"]."' name='language_check[]'>".
                            FlagIcon::widget([
                                'countryCode' => $this->countryCode,
                                'options' => [
                                    'class' => 'flag-page'
                                ]
                            ]);
                }
            }
        }
        
    }

    private function currentLanguage(){
        
        if(!Yii::$app->request->get('lang_create')){
            foreach($this->languages as $language){
                if($language["value"] == true){
                    return $language["language"];
                }else{
                    return "en";
                }
            }
        }
        return Yii::$app->request->get('lang_create');
    }
}
