<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%decoration_color}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%band_of_decoration}}`
 */
class M220128110113AddBandOfDecorationIdColumnToDecorationColorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%decoration_color}}', 'band_of_decoration_id', $this->integer()->null());

        // creates index for column `band_of_decoration_id`
        $this->createIndex(
            '{{%idx-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}',
            'band_of_decoration_id'
        );

        // add foreign key for table `{{%band_of_decoration}}`
        $this->addForeignKey(
            '{{%fk-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}',
            'band_of_decoration_id',
            '{{%band_of_decoration}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%band_of_decoration}}`
        $this->dropForeignKey(
            '{{%fk-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}'
        );

        // drops index for column `band_of_decoration_id`
        $this->dropIndex(
            '{{%idx-decoration_color-band_of_decoration_id}}',
            '{{%decoration_color}}'
        );

        $this->dropColumn('{{%decoration_color}}', 'band_of_decoration_id');
    }
}
