<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%band_of_decoration}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220204143817AddDecorationIdColumnToBandOfDecorationTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%band_of_decoration}}', 'decoration_id', $this->integer()->null());

        // creates index for column `decoration_id`
        $this->createIndex(
            '{{%idx-band_of_decoration-decoration_id}}',
            '{{%band_of_decoration}}',
            'decoration_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-band_of_decoration-decoration_id}}',
            '{{%band_of_decoration}}',
            'decoration_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-band_of_decoration-decoration_id}}',
            '{{%band_of_decoration}}'
        );

        // drops index for column `decoration_id`
        $this->dropIndex(
            '{{%idx-band_of_decoration-decoration_id}}',
            '{{%band_of_decoration}}'
        );

        $this->dropColumn('{{%band_of_decoration}}', 'decoration_id');
    }
}
