<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%decoration_color}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220204150307AddDecorationIdColumnToDecorationColorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%decoration_color}}', 'decoration_id', $this->integer()->null());

        // creates index for column `decoration_id`
        $this->createIndex(
            '{{%idx-decoration_color-decoration_id}}',
            '{{%decoration_color}}',
            'decoration_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-decoration_color-decoration_id}}',
            '{{%decoration_color}}',
            'decoration_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-decoration_color-decoration_id}}',
            '{{%decoration_color}}'
        );

        // drops index for column `decoration_id`
        $this->dropIndex(
            '{{%idx-decoration_color-decoration_id}}',
            '{{%decoration_color}}'
        );

        $this->dropColumn('{{%decoration_color}}', 'decoration_id');
    }
}
