<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use Emberware\Evidia\Toolkit\Model\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;

/**
 * This is the model common class for table "customer".
 */
class Customer extends base\Customer
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public static function find(){
        return parent::find()->where([
            'status' => 30, //prodotti non cancellati
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [
            'welcome_message' => Yii::t('app', 'Messaggio di benvenuto'),
        ]);
    }
    
}
