<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;

/**
 * This is the model extends model Language for table "Language".
 */
class Language extends base\Language
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    public static function setCurrentUserLanguage($event){
        $language = UserOption::getCurrentUserOne('language');
        if($language){
            Yii::$app->language = $language;
            Yii::$app->sourceLanguage = $language;
        }
    }
}
