<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="band-of-decoration-color-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            'id' => 'band-of-decoration-color-table',
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'id'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->id, [Yii::$app->controller->id.'/view','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Band of decoration'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->bandOfDecoration->title;}
                ],
                ['attribute'=>Yii::t('app', 'Decoration Color'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return $data->decorationColor->title;}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>