<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\BandOfDecorationColor */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="band-of-decoration-color-form">

    <?php $form = ActiveForm::begin(); ?>
        <div class="row">
            <div class="col-md-6 col-xs-12">
                <?= $form->field($model, 'band_of_decoration_id')->widget(Select2::classname(), [
                    'name' => 'band_of_decoration_id',
                    'class' => 'form-group band_of_decoration_ids form-control',
                    'value' => ArrayHelper::map($bandOfDecorations, 'id', function ($bandOfDecoration) {
                        return $bandOfDecoration['title'];
                    }),
                    'id' => 'product_id',
                    'data' => ArrayHelper::map($bandOfDecorations, 'id', function ($bandOfDecoration) {
                        return $bandOfDecoration['title'];
                    }),
                    'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select band of decoration')]
                ])->label(Yii::t('app', 'Band of decoration'));?>
            </div>
        </div>

        <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'decoration_color_id')->widget(Select2::classname(), [
                'name' => 'decoration_color_id',
                'class' => 'form-group decoration_color_ids form-control',
                'value' => ArrayHelper::map($decorationColors, 'id', function ($decorationColor) {
                    return $decorationColor['title'];
                }),
                'id' => 'product_id',
                'data' => ArrayHelper::map($decorationColors, 'id', function ($decorationColor) {
                    return $decorationColor['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select decoration color')]
            ])->label(Yii::t('app', 'Decoration color'));?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
