<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model bitcream\ndt\custom\common\models\Favourites */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="favourites-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'customer_user_id')->widget(Select2::classname(), [
                'name' => 'customer_user_id',
                'class' => 'form-group customer_user_ids form-control',
                'value' => ArrayHelper::map($customerUsers, 'id', function ($customerUser) {
                    return $customerUser['name']." ".$customerUser['surname'];
                }),
                'id' => 'collection_id',
                'data' => ArrayHelper::map($customerUsers, 'id', function ($customerUser) {
                    return $customerUser['name']." ".$customerUser['surname'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select customer user')]
            ])->label(Yii::t('app', 'Customer user'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'collection_id')->widget(Select2::classname(), [
                'name' => 'collection_id',
                'class' => 'form-group collection_ids form-control',
                'value' => ArrayHelper::map($collections, 'id', function ($collection) {
                    return $collection['title'];
                }),
                'id' => 'collection_id',
                'data' => ArrayHelper::map($collections, 'id', function ($collection) {
                    return $collection['title'];
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select collection')]
            ])->label(Yii::t('app', 'Collections'));?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 col-xs-12">
            <?= $form->field($model, 'decoration_color_id')->widget(Select2::classname(), [
                'name' => 'decoration_color_id',
                'class' => 'form-group decoration_color_ids form-control',
                'value' => ArrayHelper::map($decorationColors, 'id', function ($decorationColor) {
                    return $decorationColor->decoration->title." - ".$decorationColor->bandOfDecoration->introduction_text;
                }),
                'id' => 'collection_id',
                'data' => ArrayHelper::map($decorationColors, 'id', function ($decorationColor) {
                    return $decorationColor->decoration->title." - ".$decorationColor->bandOfDecoration->introduction_text;
                }),
                'options' => ['multiple' => false, 'placeholder' => Yii::t('app', 'Select decoration color')]
            ])->label(Yii::t('app', 'Decoration color'));?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
