<?php

namespace bitcream\ndt\custom\common\models\base;

use Yii;

/**
 * This is the model class for table "favourites".
 *
 * @property int $id
 * @property int|null $status
 * @property string|null $created_at
 * @property int|null $created_user_id
 * @property string|null $updated_at
 * @property int|null $updated_user_id
 * @property int|null $collection_id
 * @property int|null $customer_user_id
 *
 * @property Collection $collection
 */
class Favourites extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'favourites';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['status', 'created_user_id', 'updated_user_id', 'collection_id', 'customer_user_id'], 'integer'],
            [['created_at', 'updated_at'], 'string', 'max' => 255],
            [['collection_id'], 'exist', 'skipOnError' => true, 'targetClass' => Collection::className(), 'targetAttribute' => ['collection_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'status' => Yii::t('app', 'Status'),
            'created_at' => Yii::t('app', 'Created At'),
            'created_user_id' => Yii::t('app', 'Created User ID'),
            'updated_at' => Yii::t('app', 'Updated At'),
            'updated_user_id' => Yii::t('app', 'Updated User ID'),
            'collection_id' => Yii::t('app', 'Collection ID'),
            'customer_user_id' => Yii::t('app', 'Customer User ID'),
        ];
    }

    /**
     * Gets query for [[Collection]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCollection()
    {
        return $this->hasOne(Collection::className(), ['id' => 'collection_id']);
    }
}
