<?php

namespace bitcream\ndt\custom\console\migrations;

use yii\db\Migration;

/**
 * Handles adding columns to table `{{%band_of_decoration_color}}`.
 * Has foreign keys to the tables:
 *
 * - `{{%product}}`
 */
class M220210145409AddDecorationColorIdColumnToBandOfDecorationColorTable extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%band_of_decoration_color}}', 'decoration_color_id', $this->integer()->null());

        // creates index for column `decoration_color_id`
        $this->createIndex(
            '{{%idx-band_of_decoration_color-decoration_color_id}}',
            '{{%band_of_decoration_color}}',
            'decoration_color_id'
        );

        // add foreign key for table `{{%product}}`
        $this->addForeignKey(
            '{{%fk-band_of_decoration_color-decoration_color_id}}',
            '{{%band_of_decoration_color}}',
            'decoration_color_id',
            '{{%product}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        // drops foreign key for table `{{%product}}`
        $this->dropForeignKey(
            '{{%fk-band_of_decoration_color-decoration_color_id}}',
            '{{%band_of_decoration_color}}'
        );

        // drops index for column `decoration_color_id`
        $this->dropIndex(
            '{{%idx-band_of_decoration_color-decoration_color_id}}',
            '{{%band_of_decoration_color}}'
        );

        $this->dropColumn('{{%band_of_decoration_color}}', 'decoration_color_id');
    }
}
