<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\BandOfDecorationColor;
use bitcream\ndt\custom\common\models\BandOfDecoration;
use bitcream\ndt\custom\common\models\DecorationColor;
use bitcream\ndt\custom\common\models\BandOfDecorationColorSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * BandOfDecorationColorController implements the CRUD actions for BandOfDecorationColor model.
 */
class BandOfDecorationColorController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all BandOfDecorationColor models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new BandOfDecorationColorSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single BandOfDecorationColor model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new BandOfDecorationColor model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new BandOfDecorationColor();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('create', [
            'model' => $model,
            'decorationColors' => DecorationColor::find()->all(),
            'bandOfDecorations' => BandOfDecoration::find()->where(['status' => 30])->all(),
        ]);
    }

    /**
     * Updates an existing BandOfDecorationColor model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
            'decorationColors' => DecorationColor::find()->all(),
            'bandOfDecorations' => BandOfDecoration::find()->where(['status' => 30])->all(),
        ]);
    }

    /**
     * Deletes an existing BandOfDecorationColor model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the BandOfDecorationColor model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return BandOfDecorationColor the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = BandOfDecorationColor::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
