<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="band-of-decoration-datatable">
    <?= DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Title'),
                    'format'=>'raw',
                    'value' => function ($model, $key, $index, $column) use ($decoration)
                    {return Html::a($model->title, ['band-of-decoration/view','id'=>$model->id, 'decoration' => $decoration]);}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>