<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use yii2tech\ar\softdelete\SoftDeleteBehavior;
use bitcream\ndt\custom\common\behaviors\StatusBehaviors;
use bitcream\ndt\custom\common\behaviors\CreateUpdateBehaviors;
use yii\helpers\Inflector;

/**
 * This is the model common class for table "collection".
 */
class Collection extends base\Collection
{
    public function behaviors()
    {
        return array_merge(parent::behaviors(), [
            'softDeleteBehavior' => [
                'class' => SoftDeleteBehavior::className(),
                'softDeleteAttributeValues' => [
                    'status' => 0
                ],
                'replaceRegularDelete' => true // mutate native `delete()` method
            ],
            'status' => [
                'class' => StatusBehaviors::className(),
            ],
            'create-update' => [
                'class' => CreateUpdateBehaviors::className(),
            ],
       ]);
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }

    /**
     * Gets query for [[BandOfDecorations]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getBandOfDecorations()
    {
        return $this->hasMany(BandOfDecoration::className(), ['collection_id' => 'id']);
    }


    public function fields(){
        return [
            'id',
            'title',
            'slug' => 'slug',
            'description',            
            'decorsRow' => 'bandOfDecorations'
        ];
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }
    
}
