<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use emberware\evidia\useroptions\common\models\UserOption;
use emberware\evidia\users\common\models\User;
/**
 * This is the model class for table "{{%user}}".
 */
class CustomerUser extends \emberware\evidia\users\common\models\User
{    
    public static function getCurrentUser(){

        return CustomerUser::findOne(Yii::$app->user->id);
    }

    public function createUser($userData){
        $model = new User();
        $model->username = $userData['username'];
        $model->name = $userData['name'];
        $model->surname = $userData['surname'];
        $model->email = $userData['email'];
        $model->password_hash = Yii::$app->security->generatePasswordHash($userData['password_hash']);
        $model->auth_key = $model->generateAuthKey();
        $model->created_user_id = Yii::$app->user->id;
        $model->updated_user_id = Yii::$app->user->id;
        $model->created_at = (string)time();
        $model->updated_at = (string)time();
        $model->status = 30;
        $model->date_subscription = (string)time();
        $model->save();

        $customerUser = CustomerUser::findOne($model->id);
        $customerUser->setCustomerCod($userData['customerCod']);

        $auth = \Yii::$app->authManager;
        $customerUserRole = $auth->getRole('customer');
        $auth->assign($customerUserRole, $model->id);

        return $customerUser;
    }
}