<?php
namespace bitcream\ndt\custom\common\widget;

use yii\helpers\Html;
use yii\widgets\InputWidget;
use Yii;
use yii\helpers\ArrayHelper;

class ProductFieldWidget extends InputWidget
{
    private $configuration;
    public $options;
    public function init()
    {
        parent::init();
        $this->setDefaultConfiguration();
    }

    public function run()
    {
        $attribute = $this->model->getDynamicAttribute($this->attribute);
        switch ($attribute->type) {
            case 'si-no':
                return \Emberware\Evidia\Toolkit\Field\SwitchInput::Widget($this->configuration);
                break;
            case 'date':
                return \Emberware\Evidia\Toolkit\Field\Date::Widget($this->configuration);
                break;
            case 'selezione-multipla':
            case 'selezione-singola':
                return \kartik\select2\Select2::widget($this->selectConfiguration($this->attribute));
                break;
            case 'testo':
            default:
                return Html::activeTextInput($this->model, $this->attribute, ['class' => 'form-control']);
                break;
        }
    }

    private function setDefaultConfiguration(){
        $this->configuration = [
            'model' => $this->model,
            'attribute' => $this->attribute,        
        ];
    }

    private function selectConfiguration($attribute){
        switch ($attribute) {
            case 'features':
                return ArrayHelper::merge($this->configuration, [
                    'name' => 'features',
                    'data' => [
                        "con-nodi" => "Con nodi", 
                        "rigato" => "Rigato", 
                        "trattato" => "Trattato", 
                        "tavolato" => "Tavolato", 
                    ],
                    'value' => $this->model->features,
                    'options' => [
                        'placeholder' => 'Select a features ...'
                    ],
                ]);
                break;                  
            case 'development':
                return ArrayHelper::merge($this->configuration, [
                    'name' => 'development',
                    'data' => [
                        "1" => "val 1", 
                        "2" => "val 2", 
                    ],
                    'value' => $this->model->development,
                    'options' => [
                        'placeholder' => 'Select a development ...'
                    ],
                ]);
                break; 
            case 'intended_use':
                return ArrayHelper::merge($this->configuration, [
                    'name' => 'intendedUse',
                    'data' => [
                        "valore" => "valore", 
                        "valore 2" => "valore 2", 
                    ],
                    'value' => $this->model->intended_use,
                    'options' => [
                        'multiple' => true,
                        'placeholder' => 'Select a intended use ...'
                    ],
                ]);
                break; 
            default:
                return $this->configuration;
                break;
        }
    }
}