<?php

namespace bitcream\ndt\custom\backend\controllers;

use Yii;
use bitcream\ndt\custom\common\models\BandOfDecoration;
use bitcream\ndt\custom\common\models\Decoration;
use bitcream\ndt\custom\common\models\DecorationColorSearch;
use bitcream\ndt\custom\common\models\Collection;
use bitcream\ndt\custom\common\models\BandOfDecorationSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * BandOfDecorationController implements the CRUD actions for BandOfDecoration model.
 */
class BandOfDecorationController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all BandOfDecoration models.
     * @return mixed
     */
    public function actionIndex($decoration = NULL)
    {
        $searchModel = new BandOfDecorationSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'decoration' => $decoration,
        ]);
    }

    /**
     * Displays a single BandOfDecoration model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    { 
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new BandOfDecoration model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($collection = NULL)
    {
        $model = new BandOfDecoration();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('create', [
            'model' => $model,
            'decorations' => Decoration::find()->all(),
            'collection' => $collection,
        ]);
    }

    /**
     * Updates an existing BandOfDecoration model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id, $collection = NULL)
    {
        $model = $this->findModel($id);
        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
            'decorations' => Decoration::find()->where(['status' => 30])->all(),
            'collection' => $collection,
        ]);
    }

    /**
     * Deletes an existing BandOfDecoration model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id, $collection = NULL)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['collection/view', 'id' => $collection]);
    }

    /**
     * Finds the BandOfDecoration model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return BandOfDecoration the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = BandOfDecoration::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
