<?php

use yii\helpers\Html;
use emberware\evidia\datatable\common\models\DataTableCustom;

?>
<div class="favourites-datatable">
    <?=        DataTableCustom::widget([
            'dataProvider' => $dataProvider,
            // 'filterModel' => $filterModel,
            // 'searchProvider' => $searchProvider,
            'columns' => [
                ['attribute'=>Yii::t('app', 'Customer user'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->customerUser->name." ".$data->customerUser->surname, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Collection'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->collection->title, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                ['attribute'=>Yii::t('app', 'Decoration color'),
                    'format'=>'raw',
                    'value' => function($data)
                    {return Html::a($data->decorationColor->title, [Yii::$app->controller->id.'/update','id'=>$data->id]);}
                ],
                [
                    'class' => '\yii\grid\ActionColumn',
                    'header' => Yii::t('app', 'Actions'),
                    'visibleButtons' => ['delete' => true, 'update' => false, 'view' => false],
                ]
            ],
            'clientOptions' => [
                "responsive"=>true,
                "language" => [
                    "url" => Yii::t('app',"//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/English.json")
                ]
            ]
        ]);
     ?>

</div>