<?php

namespace bitcream\ndt\custom\common\models;

use Yii;
use yii\helpers\ArrayHelper;
use bitcream\pim\custom\common\models\ProductModel;
use bitcream\pim\custom\common\models\Product;
use yii\helpers\Inflector;
/**
 * This is the model common class for table "decoration_color".
 */
class DecorationColor extends \bitcream\pim\custom\common\models\Product
{
    public static $modelParent = "decoration";
    public static $modelSlug = "decoration_color";

    public function fields(){
        return [
            'id',
            'title',
            'slug' => 'slug',
        ];
    }

    public function getSlug(){
        return Inflector::slug($this->title, '-');
    }
    
    public function getCode(){        
        return $this->getDynamicAttributeValue("code");        
    }

    public function setCode($value){        
        return $this->setDynamicAttribute("code", $value);        
    }
    
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return ArrayHelper::merge(parent::rules(), [

        ]);
    }

     /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return ArrayHelper::merge(parent::attributeLabels(), [

        ]);
    }
    
}
